# Building a Concordance Using Java Maps

A **concordance** is an alphabetical list of words from a text, showing how many times each word appears.
The goal of this exercise is to build such a word–frequency table using a **`Map`** in Java, a structure ideal for **key–value associations**.
Each **word** is a key, and its **occurrence count** is the value.

---

## Understanding Map Data Structures

Java provides several `Map` implementations for key–value storage:

- **`HashMap`** → stores entries in _no specific order_; offers fast lookups and updates.
- **`TreeMap`** → keeps entries _sorted_ by key.

In this example, we use a `HashMap<String, Integer>` to count word occurrences, and a `TreeSet<String>` to display the words alphabetically.

---

## Implementation Overview

1. **Input Reading**

   - The user enters a line of text via `Scanner`.

2. **Populating the Map**

   - Each word from the input is processed in `populateHashMap()`.
   - The `getOrDefault(word, 0)` method retrieves the current count (or `0` if the word is new), then increments it.

3. **Displaying the Concordance**

   - The `keySet()` of the map is wrapped in a `TreeSet` to automatically sort the words alphabetically before printing.

---

## Suggested Extensions

1. **Custom Sorting**

   - Sort words by **length**, and for ties, **alphabetically**.

2. **Manual Counting Logic**

   - Replace `getOrDefault` with an explicit `if–else` to practice conditional checks.

3. **Input Cleaning**

   - Preprocess the input string before counting:
     remove punctuation, convert to lowercase, and trim whitespace for a more accurate concordance.
