package com.wissamfawaz;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;

public class Main {
    private static Map<String, Integer> dictionary = new HashMap<>();

    public static void main(String[] args) {
        String line;
        Scanner scan = new Scanner(System.in);

        System.out.println("Enter a line of text: ");
        line = scan.nextLine();

        populateHashMap(line);
        displayOutput();

        scan.close();
    }

    private static void populateHashMap(String line) {
        String[] words = line.split("\\s+");

        for (String word : words) {
            int count = dictionary.getOrDefault(word, 0);
            dictionary.put(word, count + 1);
        }
    }

    private static void displayOutput() {
        Set<String> wordsSet = dictionary.keySet();
        TreeSet<String> wordsSorted = new TreeSet<>(wordsSet);

        for (String word : wordsSorted) {
            System.out.println(word + ": " + dictionary.get(word));
        }
    }
}